# stayawake.ps1
# Keeps Windows awake until manually stopped (Ctrl+C or window closed)

# Load the SetThreadExecutionState function from kernel32.dll
Add-Type -Name Powr -Namespace Util -MemberDefinition @'
[DllImport("kernel32.dll")]
public static extern uint SetThreadExecutionState(uint esFlags);
'@

# Flags as UInt32 so they don't go negative
$ES_CONTINUOUS       = [uint32]2147483648  # 0x80000000
$ES_SYSTEM_REQUIRED  = [uint32]1          # 0x00000001
$ES_DISPLAY_REQUIRED = [uint32]2          # 0x00000002

# Tell Windows: keep system + display awake, continuously
[Util.Powr]::SetThreadExecutionState(
    $ES_CONTINUOUS -bor $ES_SYSTEM_REQUIRED -bor $ES_DISPLAY_REQUIRED
) | Out-Null

Write-Host "Staying awake. Press Ctrl+C or close this window to restore normal sleep behavior."

try {
    while ($true) {
        Start-Sleep -Seconds 60
    }
}
finally {
    # Restore normal behavior: clear the SYSTEM/DISPLAY_REQUIRED bits
    [Util.Powr]::SetThreadExecutionState($ES_CONTINUOUS) | Out-Null
    Write-Host "Sleep restored."
}
